/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheNotExistsException;
import com.att.aft.dme2.hazelcast.cache.impl.CacheDataSerializerHook;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;

abstract class AbstractCacheOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected Data key;
    protected Object response;
    protected transient ICacheRecordStore cache;
    protected transient CacheRecord backupRecord;
    protected transient ICacheService cacheService;
    protected transient CacheWanEventPublisher wanEventPublisher;

    protected AbstractCacheOperation() {
    }

    protected AbstractCacheOperation(String name, Data key) {
        super(name);
        this.key = key;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void beforeRun() throws Exception {
        this.cacheService = (ICacheService)this.getService();
        this.cache = this.cacheService.getOrCreateRecordStore(this.name, this.getPartitionId());
        if (this.cache.isWanReplicationEnabled()) {
            this.wanEventPublisher = this.cacheService.getCacheWanEventPublisher();
        }
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        ICacheService cacheService;
        if (throwable instanceof CacheNotExistsException && (cacheService = (ICacheService)this.getService()).getCacheConfig(this.name) != null) {
            this.getLogger().finest("Retry Cache Operation from node " + this.getNodeEngine().getLocalMember());
            return ExceptionAction.RETRY_INVOCATION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof CacheNotExistsException) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("failed to execute:" + this, e);
            }
            return;
        }
        super.logError(e);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.key);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readData();
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }
}

