/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryViews;
import com.att.aft.dme2.hazelcast.cache.impl.operation.AbstractBackupCacheOperation;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import java.io.IOException;
import javax.cache.processor.EntryProcessor;

public class CacheBackupEntryProcessorOperation
extends AbstractBackupCacheOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private EntryProcessor entryProcessor;
    private Object[] arguments;

    public CacheBackupEntryProcessorOperation() {
    }

    public CacheBackupEntryProcessorOperation(String name, Data key, EntryProcessor entryProcessor, Object ... arguments) {
        super(name, key);
        this.entryProcessor = entryProcessor;
        this.arguments = arguments;
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    public void runInternal() throws Exception {
        this.cache.invoke(this.key, this.entryProcessor, this.arguments, -1);
    }

    @Override
    public void afterRunInternal() throws Exception {
        if (this.cache.isWanReplicationEnabled()) {
            CacheRecord record = this.cache.getRecord(this.key);
            if (record != null) {
                CacheEntryView<Data, Data> entryView = CacheEntryViews.createDefaultEntryView(this.key, this.getNodeEngine().getSerializationService().toData(record.getValue()), record);
                this.wanEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            } else {
                this.wanEventPublisher.publishWanReplicationRemove(this.name, this.key);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
        out.writeBoolean(this.arguments != null);
        if (this.arguments != null) {
            out.writeInt(this.arguments.length);
            for (Object arg : this.arguments) {
                out.writeObject(arg);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
        boolean hasArguments = in.readBoolean();
        if (hasArguments) {
            int size = in.readInt();
            this.arguments = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.arguments[i] = in.readObject();
            }
        }
    }
}

