/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheNotExistsException;
import com.att.aft.dme2.hazelcast.cache.impl.CacheDataSerializerHook;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.impl.AbstractNamedOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;

public class CacheClearBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
IdentifiedDataSerializable,
MutatingOperation {
    private transient ICacheRecordStore cache;

    public CacheClearBackupOperation() {
    }

    public CacheClearBackupOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        try {
            this.cache = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        }
        catch (CacheNotExistsException e) {
            this.getLogger().finest("Error while getting a cache", e);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void run() throws Exception {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 12;
    }
}

