/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.impl.CacheClearResponse;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CacheClearBackupOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import javax.cache.CacheException;

public class CacheClearOperation
extends PartitionWideCacheOperation
implements BackupAwareOperation,
MutatingOperation {
    private transient ICacheRecordStore cache;

    public CacheClearOperation() {
    }

    public CacheClearOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        this.cache = service.getRecordStore(this.name, this.getPartitionId());
    }

    @Override
    public void run() {
        if (this.cache == null) {
            return;
        }
        try {
            this.cache.clear();
            this.response = new CacheClearResponse(Boolean.TRUE);
        }
        catch (CacheException e) {
            this.response = new CacheClearResponse((Object)e);
        }
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheClearBackupOperation(this.name);
    }
}

