/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.impl.CacheDataSerializerHook;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.impl.AbstractNamedOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.Set;

public class CacheDestroyOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
MutatingOperation {
    private boolean isLocal;

    public CacheDestroyOperation() {
    }

    public CacheDestroyOperation(String name) {
        this(name, false);
    }

    public CacheDestroyOperation(String name, boolean isLocal) {
        super(name);
        this.isLocal = isLocal;
    }

    @Override
    public void run() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        service.deleteCache(this.name, this.getCallerUuid(), true);
        if (!this.isLocal) {
            this.destroyCacheOnAllMembers(this.name, this.getCallerUuid());
        }
    }

    private void destroyCacheOnAllMembers(String name, String callerUuid) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        Set<Member> members = nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            if (member.localMember() || member.getUuid().equals(callerUuid)) continue;
            CacheDestroyOperation op = new CacheDestroyOperation(name, true);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    @Override
    public int getId() {
        return 30;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.isLocal);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.isLocal = in.readBoolean();
    }
}

