/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.BackupAwareEntryProcessor;
import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryViews;
import com.att.aft.dme2.hazelcast.cache.impl.operation.AbstractMutatingCacheOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CacheBackupEntryProcessorOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CachePutBackupOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CacheRemoveBackupOperation;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.processor.EntryProcessor;

public class CacheEntryProcessorOperation
extends AbstractMutatingCacheOperation {
    private EntryProcessor entryProcessor;
    private Object[] arguments;
    private transient CacheRecord backupRecord;
    private transient EntryProcessor backupEntryProcessor;

    public CacheEntryProcessorOperation() {
    }

    public CacheEntryProcessorOperation(String name, Data key, int completionId, EntryProcessor entryProcessor, Object ... arguments) {
        super(name, key, completionId);
        this.entryProcessor = entryProcessor;
        this.arguments = arguments;
        this.completionId = completionId;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        if (this.backupEntryProcessor != null) {
            return new CacheBackupEntryProcessorOperation(this.name, this.key, this.backupEntryProcessor, this.arguments);
        }
        if (this.backupRecord != null) {
            return new CachePutBackupOperation(this.name, this.key, this.backupRecord);
        }
        return new CacheRemoveBackupOperation(this.name, this.key);
    }

    @Override
    public int getId() {
        return 24;
    }

    @Override
    public void run() throws Exception {
        this.response = this.cache.invoke(this.key, this.entryProcessor, this.arguments, this.completionId);
        if (this.entryProcessor instanceof BackupAwareEntryProcessor) {
            BackupAwareEntryProcessor processor = (BackupAwareEntryProcessor)this.entryProcessor;
            this.backupEntryProcessor = processor.createBackupEntryProcessor();
        }
        if (this.backupEntryProcessor == null) {
            this.backupRecord = this.cache.getRecord(this.key);
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.cache.isWanReplicationEnabled()) {
            CacheRecord record = this.cache.getRecord(this.key);
            if (record != null) {
                CacheEntryView<Data, Data> entryView = CacheEntryViews.createDefaultEntryView(this.key, this.getNodeEngine().getSerializationService().toData(this.backupRecord.getValue()), this.backupRecord);
                this.wanEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            } else {
                this.wanEventPublisher.publishWanReplicationRemove(this.name, this.key);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
        out.writeBoolean(this.arguments != null);
        if (this.arguments != null) {
            out.writeInt(this.arguments.length);
            for (Object arg : this.arguments) {
                out.writeObject(arg);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
        boolean hasArguments = in.readBoolean();
        if (hasArguments) {
            int size = in.readInt();
            this.arguments = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.arguments[i] = in.readObject();
            }
        }
    }
}

