/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.att.aft.dme2.hazelcast.config.CacheConfig;
import com.att.aft.dme2.hazelcast.config.CacheSimpleConfig;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.ReadonlyOperation;
import java.io.IOException;
import javax.cache.CacheException;

public class CacheGetConfigOperation
extends PartitionWideCacheOperation
implements ReadonlyOperation {
    private String simpleName;

    public CacheGetConfigOperation() {
    }

    public CacheGetConfigOperation(String name, String simpleName) {
        super(name);
        this.simpleName = simpleName;
    }

    @Override
    public void run() throws Exception {
        CacheSimpleConfig simpleConfig;
        ICacheService service = (ICacheService)this.getService();
        CacheConfig cacheConfig = service.getCacheConfig(this.name);
        if (cacheConfig == null && (simpleConfig = service.findCacheConfig(this.simpleName)) != null) {
            try {
                cacheConfig = new CacheConfig(simpleConfig);
                cacheConfig.setName(this.simpleName);
                cacheConfig.setManagerPrefix(this.name.substring(0, this.name.lastIndexOf(this.simpleName)));
                CacheConfig existingCacheConfig = service.putCacheConfigIfAbsent(cacheConfig);
                if (existingCacheConfig != null) {
                    cacheConfig = existingCacheConfig;
                }
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.response = cacheConfig;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.simpleName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.simpleName = in.readUTF();
    }

    @Override
    public int getId() {
        return 27;
    }
}

