/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.CacheMergePolicy;
import com.att.aft.dme2.hazelcast.cache.impl.CacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.operation.AbstractCacheOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CachePutBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class CacheMergeOperation
extends AbstractCacheOperation
implements BackupAwareOperation,
MutatingOperation {
    private CacheMergePolicy mergePolicy;
    private CacheEntryView<Data, Data> mergingEntry;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, Data key, CacheEntryView<Data, Data> entryView, CacheMergePolicy policy) {
        super(name, key);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
    }

    @Override
    public void run() throws Exception {
        this.backupRecord = ((CacheRecordStore)this.cache).merge(this.mergingEntry, this.mergePolicy);
    }

    @Override
    public boolean shouldBackup() {
        return this.backupRecord != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutBackupOperation(this.name, this.key, this.backupRecord);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (CacheEntryView)in.readObject();
        this.mergePolicy = (CacheMergePolicy)in.readObject();
    }

    @Override
    public int getId() {
        return 38;
    }
}

