/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheNotExistsException;
import com.att.aft.dme2.hazelcast.cache.impl.CacheDataSerializerHook;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.impl.AbstractNamedOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CachePutAllBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
IdentifiedDataSerializable,
MutatingOperation {
    private Map<Data, CacheRecord> cacheRecords;
    private transient ICacheRecordStore cache;

    public CachePutAllBackupOperation() {
    }

    public CachePutAllBackupOperation(String name, Map<Data, CacheRecord> cacheRecords) {
        super(name);
        this.cacheRecords = cacheRecords;
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        try {
            this.cache = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        }
        catch (CacheNotExistsException e) {
            this.getLogger().finest("Error while getting a cache", e);
        }
    }

    @Override
    public void run() throws Exception {
        if (this.cache == null) {
            return;
        }
        if (this.cacheRecords != null) {
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                CacheRecord record = entry.getValue();
                this.cache.putRecord(entry.getKey(), record);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.cacheRecords != null);
        if (this.cacheRecords != null) {
            out.writeInt(this.cacheRecords.size());
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                Data key = entry.getKey();
                CacheRecord record = entry.getValue();
                out.writeData(key);
                out.writeObject(record);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean recordNotNull = in.readBoolean();
        if (recordNotNull) {
            int size = in.readInt();
            this.cacheRecords = new HashMap<Data, CacheRecord>(size);
            for (int i = 0; i < size; ++i) {
                Data key = in.readData();
                CacheRecord record = (CacheRecord)in.readObject();
                this.cacheRecords.put(key, record);
            }
        }
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }
}

