/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryViews;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.operation.AbstractBackupCacheOperation;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class CachePutBackupOperation
extends AbstractBackupCacheOperation
implements BackupOperation,
MutatingOperation {
    private CacheRecord cacheRecord;
    private boolean wanOriginated;

    public CachePutBackupOperation() {
    }

    public CachePutBackupOperation(String name, Data key, CacheRecord cacheRecord) {
        super(name, key);
        if (cacheRecord == null) {
            throw new IllegalArgumentException("Cache record of backup operation cannot be null!");
        }
        this.cacheRecord = cacheRecord;
    }

    public CachePutBackupOperation(String name, Data key, CacheRecord cacheRecord, boolean wanOriginated) {
        this(name, key, cacheRecord);
        if (cacheRecord == null) {
            throw new IllegalArgumentException("Cache record of backup operation cannot be null!");
        }
        this.wanOriginated = wanOriginated;
    }

    @Override
    public void runInternal() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        ICacheRecordStore cache = service.getOrCreateRecordStore(this.name, this.getPartitionId());
        cache.putRecord(this.key, this.cacheRecord);
        this.response = Boolean.TRUE;
    }

    @Override
    public void afterRunInternal() throws Exception {
        if (!this.wanOriginated && this.cache.isWanReplicationEnabled()) {
            CacheEntryView<Data, Data> entryView = CacheEntryViews.createDefaultEntryView(this.key, this.getNodeEngine().getSerializationService().toData(this.cacheRecord.getValue()), this.cacheRecord);
            this.wanEventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.cacheRecord);
        out.writeBoolean(this.wanOriginated);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.cacheRecord = (CacheRecord)in.readObject();
        this.wanOriginated = in.readBoolean();
    }

    @Override
    public int getId() {
        return 9;
    }
}

