/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryViews;
import com.att.aft.dme2.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.att.aft.dme2.hazelcast.cache.impl.operation.AbstractMutatingCacheOperation;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CachePutBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutOperation
extends AbstractMutatingCacheOperation {
    private Data value;
    private boolean get;
    private ExpiryPolicy expiryPolicy;

    public CachePutOperation() {
    }

    public CachePutOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy, boolean get, int completionId) {
        super(name, key, completionId);
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.get = get;
    }

    @Override
    public void run() throws Exception {
        if (this.get) {
            this.response = this.cache.getAndPut(this.key, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId);
            this.backupRecord = this.cache.getRecord(this.key);
        } else {
            this.backupRecord = this.cache.put(this.key, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId);
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.cache.isWanReplicationEnabled()) {
            CacheEntryView<Data, Data> entryView = CacheEntryViews.createDefaultEntryView(this.key, this.value, this.backupRecord);
            CacheWanEventPublisher publisher = this.cacheService.getCacheWanEventPublisher();
            publisher.publishWanReplicationUpdate(this.name, entryView);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.backupRecord != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutBackupOperation(this.name, this.key, this.backupRecord);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.get);
        out.writeObject(this.expiryPolicy);
        out.writeData(this.value);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.get = in.readBoolean();
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        this.value = in.readData();
    }

    @Override
    public int getId() {
        return 3;
    }
}

