/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.operation;

import com.att.aft.dme2.hazelcast.cache.impl.CachePartitionSegment;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.config.CacheConfig;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheReplicationOperation
extends AbstractOperation {
    protected Map<String, Map<Data, CacheRecord>> data = new HashMap<String, Map<Data, CacheRecord>>();
    protected List<CacheConfig> configs;

    public CacheReplicationOperation() {
        this.configs = new ArrayList<CacheConfig>();
    }

    public CacheReplicationOperation(CachePartitionSegment segment, int replicaIndex) {
        Iterator<ICacheRecordStore> iter = segment.recordStoreIterator();
        while (iter.hasNext()) {
            ICacheRecordStore cacheRecordStore = iter.next();
            CacheConfig cacheConfig = cacheRecordStore.getConfig();
            if (cacheConfig.getAsyncBackupCount() + cacheConfig.getBackupCount() < replicaIndex) continue;
            this.data.put(cacheRecordStore.getName(), cacheRecordStore.getReadOnlyRecords());
        }
        this.configs = new ArrayList<CacheConfig>(segment.getCacheConfigs());
    }

    @Override
    public void beforeRun() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        for (CacheConfig config : this.configs) {
            service.putCacheConfigIfAbsent(config);
        }
    }

    @Override
    public void run() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
            ICacheRecordStore cache = service.getOrCreateRecordStore(entry.getKey(), this.getPartitionId());
            Map<Data, CacheRecord> map = entry.getValue();
            Iterator<Map.Entry<Data, CacheRecord>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Data, CacheRecord> next = iter.next();
                Data key = next.getKey();
                CacheRecord record = next.getValue();
                iter.remove();
                cache.putRecord(key, record);
            }
        }
        this.data.clear();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int confSize = this.configs.size();
        out.writeInt(confSize);
        for (CacheConfig config : this.configs) {
            out.writeObject(config);
        }
        int count = this.data.size();
        out.writeInt(count);
        long now = Clock.currentTimeMillis();
        for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
            Map<Data, CacheRecord> cacheMap = entry.getValue();
            int subCount = cacheMap.size();
            out.writeInt(subCount);
            out.writeUTF(entry.getKey());
            for (Map.Entry<Data, CacheRecord> e : cacheMap.entrySet()) {
                Data key = e.getKey();
                CacheRecord record = e.getValue();
                if (record.isExpiredAt(now)) continue;
                out.writeData(key);
                out.writeObject(record);
            }
            out.writeData(null);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int confSize = in.readInt();
        for (int i = 0; i < confSize; ++i) {
            CacheConfig config = (CacheConfig)in.readObject();
            this.configs.add(config);
        }
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Data key;
            int subCount = in.readInt();
            String name = in.readUTF();
            HashMap<Data, CacheRecord> m = new HashMap<Data, CacheRecord>(subCount);
            this.data.put(name, m);
            for (int j = 0; j < subCount + 1 && (key = in.readData()) != null && key.dataSize() != 0; ++j) {
                CacheRecord record = (CacheRecord)in.readObject();
                m.put(key, record);
            }
        }
    }

    public boolean isEmpty() {
        return !(this.configs != null && !this.configs.isEmpty() || this.data != null && !this.data.isEmpty());
    }
}

