/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl;

import com.att.aft.dme2.hazelcast.client.impl.ClientEngineImpl;
import com.att.aft.dme2.hazelcast.core.Client;
import com.att.aft.dme2.hazelcast.core.ClientListener;
import com.att.aft.dme2.hazelcast.core.ClientService;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.Collection;

public final class ClientServiceProxy
implements ClientService {
    private final ClientEngineImpl clientEngine;
    private final NodeEngine nodeEngine;

    public ClientServiceProxy(Node node) {
        this.clientEngine = node.clientEngine;
        this.nodeEngine = node.nodeEngine;
    }

    @Override
    public Collection<Client> getConnectedClients() {
        return this.clientEngine.getClients();
    }

    @Override
    public String addClientListener(ClientListener clientListener) {
        Preconditions.checkNotNull(clientListener, "clientListener should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:core:clientEngine", "hz:core:clientEngine", clientListener);
        return registration.getId();
    }

    @Override
    public boolean removeClientListener(String registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener("hz:core:clientEngine", "hz:core:clientEngine", registrationId);
    }
}

