/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.operations;

import com.att.aft.dme2.hazelcast.client.ClientEndpoint;
import com.att.aft.dme2.hazelcast.client.ClientEndpointManager;
import com.att.aft.dme2.hazelcast.client.impl.ClientEngineImpl;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ClientAwareService;
import com.att.aft.dme2.hazelcast.spi.UrgentSystemOperation;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class ClientDisconnectionOperation
extends AbstractOperation
implements UrgentSystemOperation {
    private String clientUuid;

    public ClientDisconnectionOperation() {
    }

    public ClientDisconnectionOperation(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Override
    public void run() throws Exception {
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        ClientEndpointManager endpointManager = engine.getEndpointManager();
        Set<ClientEndpoint> endpoints = endpointManager.getEndpoints(this.clientUuid);
        for (ClientEndpoint endpoint : endpoints) {
            endpointManager.removeEndpoint(endpoint, true);
        }
        engine.removeOwnershipMapping(this.clientUuid);
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        nodeEngine.onClientDisconnected(this.clientUuid);
        Collection<ClientAwareService> services = nodeEngine.getServices(ClientAwareService.class);
        for (ClientAwareService service : services) {
            service.clientDisconnected(this.clientUuid);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
    }
}

