/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.operations;

import com.att.aft.dme2.hazelcast.client.ClientEndpoint;
import com.att.aft.dme2.hazelcast.client.impl.ClientEngineImpl;
import com.att.aft.dme2.hazelcast.client.impl.client.ClientPrincipal;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.UrgentSystemOperation;
import java.io.IOException;
import java.util.Set;

public class ClientReAuthOperation
extends AbstractOperation
implements UrgentSystemOperation {
    private String clientUuid;

    public ClientReAuthOperation() {
    }

    public ClientReAuthOperation(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Override
    public void run() throws Exception {
        ClientEngineImpl service = (ClientEngineImpl)this.getService();
        String memberUuid = this.getCallerUuid();
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        Set<ClientEndpoint> endpoints = engine.getEndpointManager().getEndpoints(this.clientUuid);
        for (ClientEndpoint endpoint : endpoints) {
            ClientPrincipal principal = new ClientPrincipal(this.clientUuid, memberUuid);
            endpoint.authenticated(principal);
        }
        service.addOwnershipMapping(this.clientUuid, memberUuid);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
    }
}

