/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.codec;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.att.aft.dme2.hazelcast.nio.Address;
import java.net.UnknownHostException;

public final class AddressCodec {
    private AddressCodec() {
    }

    public static Address decode(ClientMessage clientMessage) {
        String host = clientMessage.getStringUtf8();
        int port = clientMessage.getInt();
        try {
            return new Address(host, port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void encode(Address address, ClientMessage clientMessage) {
        clientMessage.set(address.getHost()).set(address.getPort());
    }

    public static int calculateDataSize(Address address) {
        int dataSize = ParameterUtil.calculateDataSize(address.getHost());
        return dataSize += 4;
    }
}

