/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.codec;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.att.aft.dme2.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapExecuteWithPredicateCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_EXECUTEWITHPREDICATE;
    public static final int RESPONSE_TYPE = 117;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data entryProcessor, Data predicate) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, entryProcessor, predicate);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(entryProcessor);
        clientMessage.set(predicate);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data entryProcessor = null;
        parameters.entryProcessor = entryProcessor = clientMessage.getData();
        Data predicate = null;
        parameters.predicate = predicate = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<Map.Entry<Data, Data>> response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(117);
        clientMessage.set(response.size());
        for (Map.Entry<Data, Data> response_item : response) {
            Data key = response_item.getKey();
            Data val = response_item.getValue();
            clientMessage.set(key);
            clientMessage.set(val);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<Map.Entry<Data, Data>> response = null;
        int response_size = clientMessage.getInt();
        response = new ArrayList<Map.Entry<Data, Data>>(response_size);
        for (int response_index = 0; response_index < response_size; ++response_index) {
            Data response_item_key = clientMessage.getData();
            Data response_item_val = clientMessage.getData();
            AbstractMap.SimpleEntry<Data, Data> response_item = new AbstractMap.SimpleEntry<Data, Data>(response_item_key, response_item_val);
            response.add(response_item);
        }
        parameters.response = response;
        return parameters;
    }

    public static class ResponseParameters {
        public List<Map.Entry<Data, Data>> response;

        public static int calculateDataSize(Collection<Map.Entry<Data, Data>> response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Map.Entry<Data, Data> response_item : response) {
                Data key = response_item.getKey();
                Data val = response_item.getValue();
                dataSize += ParameterUtil.calculateDataSize(key);
                dataSize += ParameterUtil.calculateDataSize(val);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data entryProcessor;
        public Data predicate;

        public static int calculateDataSize(String name, Data entryProcessor, Data predicate) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(entryProcessor);
            return dataSize += ParameterUtil.calculateDataSize(predicate);
        }
    }
}

