/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.codec;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.QueueMessageType;
import com.att.aft.dme2.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class QueuePutCodec {
    public static final QueueMessageType REQUEST_TYPE = QueueMessageType.QUEUE_PUT;
    public static final int RESPONSE_TYPE = 100;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data value) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, value);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(value);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data value = null;
        parameters.value = value = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final QueueMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data value;

        public static int calculateDataSize(String name, Data value) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            return dataSize += ParameterUtil.calculateDataSize(value);
        }
    }
}

