/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.att.aft.dme2.hazelcast.core.ExecutionCallback;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.att.aft.dme2.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.att.aft.dme2.hazelcast.util.executor.ManagedExecutorService;
import java.util.concurrent.Executor;

public abstract class AbstractPartitionMessageTask<P>
extends AbstractMessageTask<P>
implements ExecutionCallback,
Executor {
    protected AbstractPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void beforeProcess() {
    }

    protected void beforeResponse() {
    }

    protected void afterResponse() {
    }

    @Override
    public final void processMessage() {
        this.beforeProcess();
        Operation op = this.prepareOperation();
        op.setCallerUuid(this.endpoint.getUuid());
        InternalCompletableFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.getPartitionId()).setResultDeserialized(false).invoke();
        f.andThen(this, this);
    }

    protected abstract Operation prepareOperation();

    @Override
    public void execute(Runnable command) {
        if (Thread.currentThread().getClass() == PartitionOperationThread.class) {
            command.run();
        } else {
            InternalExecutionService executionService = this.nodeEngine.getExecutionService();
            ManagedExecutorService executor = executionService.getExecutor("hz:async");
            executor.execute(command);
        }
    }

    public void onResponse(Object response) {
        this.beforeResponse();
        this.sendResponse(response);
        this.afterResponse();
    }

    @Override
    public void onFailure(Throwable t) {
        this.beforeResponse();
        this.handleProcessingFailure(t);
        this.afterResponse();
    }
}

