/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task;

import com.att.aft.dme2.hazelcast.client.impl.client.ClientPrincipal;
import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.UsernamePasswordCredentials;

public class AuthenticationMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCodec.RequestParameters> {
    public AuthenticationMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientAuthenticationCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCodec.RequestParameters parameters = ClientAuthenticationCodec.decodeRequest(clientMessage);
        String uuid = parameters.uuid;
        String ownerUuid = parameters.ownerUuid;
        if (uuid != null && uuid.length() > 0) {
            this.principal = new ClientPrincipal(uuid, ownerUuid);
        }
        this.credentials = new UsernamePasswordCredentials(parameters.username, parameters.password);
        this.clientSerializationVersion = parameters.serializationVersion;
        return parameters;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, String uuid, String ownerUuid, byte version) {
        return ClientAuthenticationCodec.encodeResponse(status, thisAddress, uuid, ownerUuid, version);
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected boolean isOwnerConnection() {
        return ((ClientAuthenticationCodec.RequestParameters)this.parameters).isOwnerConnection;
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCodec.RequestParameters)this.parameters).clientType;
    }
}

