/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.spi.partition.IPartition;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;

public class GetPartitionsMessageTask
extends AbstractCallableMessageTask<ClientGetPartitionsCodec.RequestParameters> {
    public GetPartitionsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        InternalPartitionService service = (InternalPartitionService)this.getService("hz:core:partitionService");
        service.firstArrangement();
        HashMap<Address, LinkedList<Integer>> partitionsMap = new HashMap<Address, LinkedList<Integer>>();
        for (IPartition partition : service.getPartitions()) {
            Address owner = partition.getOwnerOrNull();
            if (owner == null) {
                partitionsMap.clear();
                return ClientGetPartitionsCodec.encodeResponse(partitionsMap.entrySet());
            }
            LinkedList<Integer> indexes = (LinkedList<Integer>)partitionsMap.get(owner);
            if (indexes == null) {
                indexes = new LinkedList<Integer>();
                partitionsMap.put(owner, indexes);
            }
            indexes.add(partition.getPartitionId());
        }
        return ClientGetPartitionsCodec.encodeResponse(partitionsMap.entrySet());
    }

    @Override
    protected ClientGetPartitionsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientGetPartitionsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

