/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.cache;

import com.att.aft.dme2.hazelcast.cache.impl.CacheOperationProvider;
import com.att.aft.dme2.hazelcast.cache.impl.CacheService;
import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.CacheSizeCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.cache.AbstractCacheAllPartitionsTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import java.util.Map;

public class CacheSizeMessageTask
extends AbstractCacheAllPartitionsTask<CacheSizeCodec.RequestParameters> {
    public CacheSizeMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        CacheOperationProvider operationProvider = this.getOperationProvider(((CacheSizeCodec.RequestParameters)this.parameters).name);
        return operationProvider.createSizeOperationFactory();
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        int total = 0;
        CacheService service = (CacheService)this.getService(this.getServiceName());
        for (Object result : map.values()) {
            Integer size = (Integer)service.toObject(result);
            total += size.intValue();
        }
        return total;
    }

    @Override
    protected CacheSizeCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheSizeCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheSizeCodec.encodeResponse((Integer)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheSizeCodec.RequestParameters)this.parameters).name;
    }
}

