/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import java.security.Permission;

public abstract class AbstractMapPutMessageTask<P>
extends AbstractMapPartitionMessageTask<P> {
    protected transient long startTime;

    protected AbstractMapPutMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(this.getDistributedObjectName());
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.getDistributedObjectName()).incrementPuts(latency);
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "put");
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }
}

