/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.att.aft.dme2.hazelcast.cluster.memberselector.MemberSelectors;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryOperation;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryPartitionOperation;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryResult;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryResultRow;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.att.aft.dme2.hazelcast.util.BitSetUtils;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.IterationType;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractMapQueryMessageTask<P>
extends AbstractCallableMessageTask<P> {
    protected AbstractMapQueryMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "read");
    }

    protected abstract Predicate getPredicate();

    protected abstract IterationType getIterationType();

    protected abstract Object reduce(Collection<QueryResultRow> var1);

    @Override
    protected final Object call() throws Exception {
        LinkedList<QueryResultRow> result = new LinkedList<QueryResultRow>();
        try {
            Predicate predicate = this.getPredicate();
            int partitionCount = this.clientEngine.getPartitionService().getPartitionCount();
            BitSet finishedPartitions = this.invokeOnMembers(result, predicate, partitionCount);
            this.invokeOnMissingPartitions(result, predicate, finishedPartitions, partitionCount);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return this.reduce(result);
    }

    private BitSet invokeOnMembers(Collection<QueryResultRow> result, Predicate predicate, int partitionCount) throws InterruptedException, ExecutionException {
        Collection<Member> members = this.clientEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        List<Future> futures = this.createInvocations(members, predicate);
        return this.collectResults(result, futures, partitionCount);
    }

    private void invokeOnMissingPartitions(Collection<QueryResultRow> result, Predicate predicate, BitSet finishedPartitions, int partitionCount) throws InterruptedException, ExecutionException {
        if (this.hasMissingPartitions(finishedPartitions, partitionCount)) {
            List<Integer> missingList = this.findMissingPartitions(finishedPartitions, partitionCount);
            ArrayList<Future> missingFutures = new ArrayList<Future>(missingList.size());
            this.createInvocationsForMissingPartitions(missingList, missingFutures, predicate);
            this.collectResultsFromMissingPartitions(result, missingFutures);
        }
    }

    private List<Future> createInvocations(Collection<Member> members, Predicate predicate) {
        ArrayList<Future> futures = new ArrayList<Future>(members.size());
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        for (Member member : members) {
            InternalCompletableFuture future = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.getDistributedObjectName(), predicate, this.getIterationType()), member.getAddress()).invoke();
            futures.add(future);
        }
        return futures;
    }

    private BitSet collectResults(Collection<QueryResultRow> result, List<Future> futures, int partitionCount) throws InterruptedException, ExecutionException {
        BitSet finishedPartitions = new BitSet(partitionCount);
        for (Future future : futures) {
            Collection<Integer> partitionIds;
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null || BitSetUtils.hasAtLeastOneBitSet(finishedPartitions, partitionIds)) continue;
            BitSetUtils.setBits(finishedPartitions, partitionIds);
            result.addAll(queryResult.getRows());
        }
        return finishedPartitions;
    }

    private boolean hasMissingPartitions(BitSet finishedPartitions, int partitionCount) {
        return finishedPartitions.nextClearBit(0) < partitionCount;
    }

    private List<Integer> findMissingPartitions(BitSet finishedPartitions, int partitionCount) {
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        for (int i = 0; i < partitionCount; ++i) {
            if (finishedPartitions.get(i)) continue;
            missingList.add(i);
        }
        return missingList;
    }

    private void createInvocationsForMissingPartitions(List<Integer> missingPartitionsList, List<Future> futures, Predicate predicate) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        for (Integer partitionId : missingPartitionsList) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.getDistributedObjectName(), predicate, this.getIterationType());
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, partitionId);
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    private void collectResultsFromMissingPartitions(Collection<QueryResultRow> result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            QueryResult queryResult = (QueryResult)future.get();
            result.addAll(queryResult.getRows());
        }
    }
}

