/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.MapInterceptor;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.operation.AddInterceptorOperationFactory;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapAddInterceptorMessageTask
extends AbstractMultiTargetMessageTask<MapAddInterceptorCodec.RequestParameters> {
    private transient String id;

    public MapAddInterceptorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapInterceptor mapInterceptor = (MapInterceptor)this.serializationService.toObject(((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor);
        this.id = mapServiceContext.generateInterceptorId(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, mapInterceptor);
        return new AddInterceptorOperationFactory(this.id, ((MapAddInterceptorCodec.RequestParameters)this.parameters).name, mapInterceptor);
    }

    @Override
    protected Object reduce(Map<Address, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            throw (Throwable)result;
        }
        return this.id;
    }

    @Override
    public Collection<Address> getTargets() {
        Set<Member> memberList = this.nodeEngine.getClusterService().getMembers();
        HashSet<Address> addresses = new HashSet<Address>();
        for (Member member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    protected MapAddInterceptorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddInterceptorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddInterceptorCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddInterceptorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "addInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor};
    }
}

