/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.ClientEndpoint;
import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.MapPartitionLostEvent;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.listener.MapPartitionLostListener;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import java.security.Permission;

public class MapAddPartitionLostListenerMessageTask
extends AbstractCallableMessageTask<MapAddPartitionLostListenerCodec.RequestParameters> {
    public MapAddPartitionLostListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapPartitionLostListener listener = new MapPartitionLostListener(){

            @Override
            public void partitionLost(MapPartitionLostEvent event) {
                if (endpoint.isAlive()) {
                    ClientMessage eventMessage = MapAddPartitionLostListenerCodec.encodeMapPartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                    MapAddPartitionLostListenerMessageTask.this.sendClientMessage(null, eventMessage);
                }
            }
        };
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        String registrationId = ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).localOnly ? mapServiceContext.addLocalPartitionLostListener(listener, ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name) : mapServiceContext.addPartitionLostListener(listener, ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name);
        endpoint.addListenerDestroyAction("hz:impl:mapService", ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected MapAddPartitionLostListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddPartitionLostListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddPartitionLostListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name;
    }
}

