/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.event.MapEventPublisher;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperationProvider;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.Map;

public class MapClearMessageTask
extends AbstractMapAllPartitionsMessageTask<MapClearCodec.RequestParameters> {
    public MapClearMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getOperationProvider(((MapClearCodec.RequestParameters)this.parameters).name);
        return operationProvider.createClearOperationFactory(((MapClearCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        int clearedTotal = 0;
        for (Object affectedEntries : map.values()) {
            clearedTotal += ((Integer)affectedEntries).intValue();
        }
        MapService service = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        if (clearedTotal > 0) {
            Address thisAddress = this.nodeEngine.getThisAddress();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            mapEventPublisher.publishMapEvent(thisAddress, ((MapClearCodec.RequestParameters)this.parameters).name, EntryEventType.CLEAR_ALL, clearedTotal);
            this.sendClientNearCacheClearEvent(((MapClearCodec.RequestParameters)this.parameters).name);
        }
        return null;
    }

    @Override
    protected MapClearCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapClearCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapClearCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapClearCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapClearCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "clear";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

