/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractMultiPartitionMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.map.EntryProcessor;
import com.att.aft.dme2.hazelcast.map.impl.MapEntries;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.operation.MultipleEntryOperationFactory;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapExecuteOnKeysMessageTask
extends AbstractMultiPartitionMessageTask<MapExecuteOnKeysCodec.RequestParameters> {
    public MapExecuteOnKeysMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        EntryProcessor entryProcessor = (EntryProcessor)this.serializationService.toObject(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).entryProcessor);
        HashSet<Data> keys = new HashSet<Data>(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys);
        return new MultipleEntryOperationFactory(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name, keys, entryProcessor);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntries mapEntries = (MapEntries)mapService.getMapServiceContext().toObject(o);
            mapEntries.putAllToList(entries);
        }
        return entries;
    }

    @Override
    public Collection<Integer> getPartitions() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int partitions = partitionService.getPartitionCount();
        int capacity = Math.min(partitions, ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys.size());
        HashSet<Integer> partitionIds = new HashSet<Integer>(capacity);
        Iterator<Data> iterator = ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys.iterator();
        while (iterator.hasNext() && partitionIds.size() < partitions) {
            Data key = iterator.next();
            partitionIds.add(partitionService.getPartitionId(key));
        }
        return partitionIds;
    }

    @Override
    protected MapExecuteOnKeysCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapExecuteOnKeysCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapExecuteOnKeysCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "executeOnKeys";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys, ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).entryProcessor};
    }
}

