/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.impl.operation.RemoveInterceptorOperationFactory;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapRemoveInterceptorMessageTask
extends AbstractMultiTargetMessageTask<MapRemoveInterceptorCodec.RequestParameters> {
    public MapRemoveInterceptorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new RemoveInterceptorOperationFactory(((MapRemoveInterceptorCodec.RequestParameters)this.parameters).id, ((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Object reduce(Map<Address, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            throw (Throwable)result;
        }
        return true;
    }

    @Override
    public Collection<Address> getTargets() {
        Set<Member> memberList = this.nodeEngine.getClusterService().getMembers();
        HashSet<Address> addresses = new HashSet<Address>();
        for (Member member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    protected MapRemoveInterceptorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapRemoveInterceptorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveInterceptorCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveInterceptorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "removeInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveInterceptorCodec.RequestParameters)this.parameters).id};
    }
}

