/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.map;

import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperationProvider;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.security.permission.MapPermission;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.security.Permission;

public class MapRemoveMessageTask
extends AbstractMapPartitionMessageTask<MapRemoveCodec.RequestParameters> {
    protected transient long startTime;

    public MapRemoveMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(((MapRemoveCodec.RequestParameters)this.parameters).name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(((MapRemoveCodec.RequestParameters)this.parameters).name).incrementRemoves(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        MapOperationProvider operationProvider = this.getMapOperationProvider(((MapRemoveCodec.RequestParameters)this.parameters).name);
        MapOperation op = operationProvider.createRemoveOperation(((MapRemoveCodec.RequestParameters)this.parameters).name, ((MapRemoveCodec.RequestParameters)this.parameters).key, false);
        op.setThreadId(((MapRemoveCodec.RequestParameters)this.parameters).threadId);
        return op;
    }

    @Override
    protected MapRemoveCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapRemoveCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveCodec.encodeResponse(this.serializationService.toData(response));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveCodec.RequestParameters)this.parameters).key};
    }
}

