/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.queue;

import com.att.aft.dme2.hazelcast.client.ClientEndpoint;
import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.QueueAddListenerCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.att.aft.dme2.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueService;
import com.att.aft.dme2.hazelcast.core.ItemEvent;
import com.att.aft.dme2.hazelcast.core.ItemListener;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.security.permission.QueuePermission;
import java.security.Permission;

public class QueueAddListenerMessageTask
extends AbstractCallableMessageTask<QueueAddListenerCodec.RequestParameters> {
    public QueueAddListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        QueueService service = (QueueService)this.getService("hz:impl:queueService");
        Object partitionKey = this.serializationService.toData(((QueueAddListenerCodec.RequestParameters)this.parameters).name);
        ItemListener listener = new ItemListener((Data)partitionKey){
            final /* synthetic */ Data val$partitionKey;
            {
                this.val$partitionKey = data;
            }

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareItemEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareItemEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)event;
                    Data item = dataAwareItemEvent.getItemData();
                    ClientMessage clientMessage = QueueAddListenerCodec.encodeItemEvent(item, event.getMember().getUuid(), event.getEventType().getType());
                    QueueAddListenerMessageTask.this.sendClientMessage(this.val$partitionKey, clientMessage);
                }
            }
        };
        String registrationId = service.addItemListener(((QueueAddListenerCodec.RequestParameters)this.parameters).name, listener, ((QueueAddListenerCodec.RequestParameters)this.parameters).includeValue, ((QueueAddListenerCodec.RequestParameters)this.parameters).localOnly);
        endpoint.addListenerDestroyAction("hz:impl:queueService", ((QueueAddListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected QueueAddListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return QueueAddListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return QueueAddListenerCodec.encodeResponse((String)response);
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null, ((QueueAddListenerCodec.RequestParameters)this.parameters).includeValue};
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(((QueueAddListenerCodec.RequestParameters)this.parameters).name, "listen");
    }

    @Override
    public String getMethodName() {
        return "addItemListener";
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public String getDistributedObjectName() {
        return ((QueueAddListenerCodec.RequestParameters)this.parameters).name;
    }
}

