/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.client.impl.protocol.task.set;

import com.att.aft.dme2.hazelcast.client.ClientEndpoint;
import com.att.aft.dme2.hazelcast.client.impl.protocol.ClientMessage;
import com.att.aft.dme2.hazelcast.client.impl.protocol.codec.SetAddListenerCodec;
import com.att.aft.dme2.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionEventFilter;
import com.att.aft.dme2.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.att.aft.dme2.hazelcast.core.ItemEvent;
import com.att.aft.dme2.hazelcast.core.ItemListener;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.security.permission.SetPermission;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.EventService;
import java.security.Permission;

public class SetAddListenerMessageTask
extends AbstractCallableMessageTask<SetAddListenerCodec.RequestParameters> {
    public SetAddListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ClientEndpoint endpoint = this.getEndpoint();
        Object partitionKey = this.serializationService.toData(((SetAddListenerCodec.RequestParameters)this.parameters).name);
        ItemListener listener = this.createItemListener(endpoint, (Data)partitionKey);
        EventService eventService = this.clientEngine.getEventService();
        CollectionEventFilter filter = new CollectionEventFilter(((SetAddListenerCodec.RequestParameters)this.parameters).includeValue);
        EventRegistration registration = ((SetAddListenerCodec.RequestParameters)this.parameters).localOnly ? eventService.registerLocalListener(this.getServiceName(), ((SetAddListenerCodec.RequestParameters)this.parameters).name, filter, listener) : eventService.registerListener(this.getServiceName(), ((SetAddListenerCodec.RequestParameters)this.parameters).name, filter, listener);
        String registrationId = registration.getId();
        endpoint.addListenerDestroyAction(this.getServiceName(), ((SetAddListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    private ItemListener createItemListener(final ClientEndpoint endpoint, final Data partitionKey) {
        return new ItemListener(){

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareItemEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareItemEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)event;
                    Data item = dataAwareItemEvent.getItemData();
                    ClientMessage clientMessage = SetAddListenerCodec.encodeItemEvent(item, event.getMember().getUuid(), event.getEventType().getType());
                    SetAddListenerMessageTask.this.sendClientMessage(partitionKey, clientMessage);
                }
            }
        };
    }

    @Override
    protected SetAddListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SetAddListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return SetAddListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:setService";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null, ((SetAddListenerCodec.RequestParameters)this.parameters).includeValue};
    }

    @Override
    public Permission getRequiredPermission() {
        return new SetPermission(((SetAddListenerCodec.RequestParameters)this.parameters).name, "listen");
    }

    @Override
    public String getMethodName() {
        return "addItemListener";
    }

    @Override
    public String getDistributedObjectName() {
        return ((SetAddListenerCodec.RequestParameters)this.parameters).name;
    }
}

