/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cluster.impl;

import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.InterfacesConfig;
import com.att.aft.dme2.hazelcast.config.NetworkConfig;
import com.att.aft.dme2.hazelcast.config.TcpIpConfig;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.AbstractJoiner;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.JoinMessage;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.MasterClaimOperation;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.util.AddressUtil;
import com.att.aft.dme2.hazelcast.util.Clock;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class TcpIpJoiner
extends AbstractJoiner {
    private static final long JOIN_RETRY_WAIT_TIME = 1000L;
    private static final int LOOK_FOR_MASTER_MAX_TRY_COUNT = 20;
    private final int maxPortTryCount;
    private volatile boolean claimingMaster;

    public TcpIpJoiner(Node node) {
        super(node);
        int tryCount = node.getProperties().getInteger(GroupProperty.TCP_JOIN_PORT_TRY_COUNT);
        if (tryCount <= 0) {
            throw new IllegalArgumentException(String.format("%s should be greater than zero! Current value: %d", GroupProperty.TCP_JOIN_PORT_TRY_COUNT, tryCount));
        }
        this.maxPortTryCount = tryCount;
    }

    public boolean isClaimingMaster() {
        return this.claimingMaster;
    }

    protected int getConnTimeoutSeconds() {
        return this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
    }

    @Override
    public void doJoin() {
        Address targetAddress = this.getTargetAddress();
        if (targetAddress != null) {
            long maxJoinMergeTargetMillis = this.node.getProperties().getMillis(GroupProperty.MAX_JOIN_MERGE_TARGET_SECONDS);
            this.joinViaTargetMember(targetAddress, maxJoinMergeTargetMillis);
            if (!this.node.joined()) {
                this.joinViaPossibleMembers();
            }
        } else if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            Address requiredMember = this.getRequiredMemberAddress();
            long maxJoinMillis = this.getMaxJoinMillis();
            this.joinViaTargetMember(requiredMember, maxJoinMillis);
        } else {
            this.joinViaPossibleMembers();
        }
    }

    private void joinViaTargetMember(Address targetAddress, long maxJoinMillis) {
        try {
            if (targetAddress == null) {
                throw new IllegalArgumentException("Invalid target address -> NULL");
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Joining over target member " + targetAddress);
            }
            if (targetAddress.equals(this.node.getThisAddress()) || this.isLocalAddress(targetAddress)) {
                this.node.setAsMaster();
                return;
            }
            long joinStartTime = Clock.currentTimeMillis();
            while (this.node.isRunning() && !this.node.joined() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
                Connection connection = this.node.connectionManager.getOrConnect(targetAddress);
                if (connection == null) {
                    Thread.sleep(1000L);
                    continue;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Sending joinRequest " + targetAddress);
                }
                this.clusterJoinManager.sendJoinRequest(targetAddress, true);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
    }

    private void joinViaPossibleMembers() {
        try {
            this.blacklistedAddresses.clear();
            Collection<Address> possibleAddresses = this.getPossibleAddresses();
            boolean foundConnection = this.tryInitialConnection(possibleAddresses);
            if (!foundConnection) {
                this.logger.fine("This node will assume master role since no possible member where connected to.");
                this.node.setAsMaster();
                return;
            }
            long maxJoinMillis = this.getMaxJoinMillis();
            long startTime = Clock.currentTimeMillis();
            while (this.node.isRunning() && !this.node.joined() && Clock.currentTimeMillis() - startTime < maxJoinMillis) {
                this.tryToJoinPossibleAddresses(possibleAddresses);
                if (this.node.joined()) {
                    return;
                }
                if (this.isAllBlacklisted(possibleAddresses)) {
                    this.logger.fine("This node will assume master role since none of the possible members accepted join request.");
                    this.node.setAsMaster();
                    return;
                }
                boolean masterCandidate = this.isThisNodeMasterCandidate(possibleAddresses);
                if (masterCandidate) {
                    boolean consensus = this.claimMastership(possibleAddresses);
                    if (consensus) {
                        if (this.logger.isFineEnabled()) {
                            HashSet<Address> votingEndpoints = new HashSet<Address>(possibleAddresses);
                            votingEndpoints.removeAll(this.blacklistedAddresses.keySet());
                            this.logger.fine("Setting myself as master after consensus! Voting endpoints: " + votingEndpoints);
                        }
                        this.node.setAsMaster();
                        this.claimingMaster = false;
                        return;
                    }
                } else if (this.logger.isFineEnabled()) {
                    this.logger.fine("Cannot claim myself as master! Will try to connect a possible master...");
                }
                this.claimingMaster = false;
                this.lookForMaster(possibleAddresses);
            }
        }
        catch (Throwable t) {
            this.logger.severe(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean claimMastership(Collection<Address> possibleAddresses) {
        if (this.logger.isFineEnabled()) {
            HashSet<Address> votingEndpoints = new HashSet<Address>(possibleAddresses);
            votingEndpoints.removeAll(this.blacklistedAddresses.keySet());
            this.logger.fine("Claiming myself as master node! Asking to endpoints: " + votingEndpoints);
        }
        this.claimingMaster = true;
        LinkedList responses = new LinkedList();
        for (Address address : possibleAddresses) {
            if (this.isBlacklisted(address) || this.node.getConnectionManager().getConnection(address) == null) continue;
            InternalCompletableFuture future = this.node.nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", (Operation)new MasterClaimOperation(), address).setTryCount(1).invoke();
            responses.add(future);
        }
        long maxWait = TimeUnit.SECONDS.toMillis(10L);
        long waitTime = 0L;
        boolean consensus = true;
        for (Future future : responses) {
            long t = Clock.currentTimeMillis();
            try {
                consensus = (Boolean)future.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.finest(e);
                consensus = false;
            }
            finally {
                waitTime += Clock.currentTimeMillis() - t;
            }
            if (!consensus) break;
            if (waitTime <= maxWait) continue;
            consensus = false;
            break;
        }
        return consensus;
    }

    private boolean isThisNodeMasterCandidate(Collection<Address> possibleAddresses) {
        int thisHashCode = this.node.getThisAddress().hashCode();
        for (Address address : possibleAddresses) {
            if (this.isBlacklisted(address) || this.node.connectionManager.getConnection(address) == null || thisHashCode <= address.hashCode()) continue;
            return false;
        }
        return true;
    }

    private void tryToJoinPossibleAddresses(Collection<Address> possibleAddresses) throws InterruptedException {
        long connectionTimeoutMillis = TimeUnit.SECONDS.toMillis(this.getConnTimeoutSeconds());
        long start = Clock.currentTimeMillis();
        while (!this.node.joined() && Clock.currentTimeMillis() - start < connectionTimeoutMillis) {
            Address masterAddress = this.node.getMasterAddress();
            if (this.isAllBlacklisted(possibleAddresses) && masterAddress == null) {
                return;
            }
            if (masterAddress != null) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Sending join request to " + masterAddress);
                }
                this.clusterJoinManager.sendJoinRequest(masterAddress, true);
            } else {
                this.sendMasterQuestion(possibleAddresses);
            }
            if (this.node.joined()) continue;
            Thread.sleep(1000L);
        }
    }

    private boolean tryInitialConnection(Collection<Address> possibleAddresses) throws InterruptedException {
        long connectionTimeoutMillis = TimeUnit.SECONDS.toMillis(this.getConnTimeoutSeconds());
        long start = Clock.currentTimeMillis();
        while (Clock.currentTimeMillis() - start < connectionTimeoutMillis) {
            if (this.isAllBlacklisted(possibleAddresses)) {
                return false;
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Will send master question to each address in: " + possibleAddresses);
            }
            if (this.sendMasterQuestion(possibleAddresses)) {
                return true;
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    private boolean isAllBlacklisted(Collection<Address> possibleAddresses) {
        return this.blacklistedAddresses.keySet().containsAll(possibleAddresses);
    }

    private void lookForMaster(Collection<Address> possibleAddresses) throws InterruptedException {
        Address master;
        int tryCount = 0;
        while (this.node.getMasterAddress() == null && tryCount++ < 20) {
            this.sendMasterQuestion(possibleAddresses);
            Thread.sleep(1000L);
            if (!this.isAllBlacklisted(possibleAddresses)) continue;
        }
        if (this.node.joined()) {
            return;
        }
        if (this.isAllBlacklisted(possibleAddresses) && this.node.getMasterAddress() == null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Setting myself as master! No possible addresses remaining to connect...");
            }
            this.node.setAsMaster();
            return;
        }
        long maxMasterJoinTime = this.getMaxJoinTimeToMasterNode();
        long start = Clock.currentTimeMillis();
        while (this.node.isRunning() && !this.node.joined() && Clock.currentTimeMillis() - start < maxMasterJoinTime && (master = this.node.getMasterAddress()) != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Joining to master " + master);
            }
            this.clusterJoinManager.sendJoinRequest(master, true);
            Thread.sleep(1000L);
        }
        if (!this.node.joined()) {
            master = this.node.getMasterAddress();
            if (master != null) {
                this.logger.warning("Couldn't join to the master : " + master);
            } else if (this.logger.isFineEnabled()) {
                this.logger.fine("Couldn't find a master! But there was connections available: " + possibleAddresses);
            }
        }
    }

    private boolean sendMasterQuestion(Collection<Address> possibleAddresses) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("NOT sending master question to blacklisted endpoints: " + this.blacklistedAddresses);
        }
        boolean sent = false;
        for (Address address : possibleAddresses) {
            if (this.isBlacklisted(address)) continue;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Sending master question to " + address);
            }
            if (!this.clusterJoinManager.sendMasterQuestion(address)) continue;
            sent = true;
        }
        return sent;
    }

    private Address getRequiredMemberAddress() {
        block8: {
            TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
            String host = tcpIpConfig.getRequiredMember();
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(host, this.config.getNetworkConfig().getPort());
                if (AddressUtil.isIpAddress(addressHolder.getAddress())) {
                    return new Address(addressHolder.getAddress(), addressHolder.getPort());
                }
                InterfacesConfig interfaces = this.config.getNetworkConfig().getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress[] inetAddresses = InetAddress.getAllByName(addressHolder.getAddress());
                    if (inetAddresses.length > 1) {
                        for (InetAddress inetAddress : inetAddresses) {
                            if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                            return new Address(inetAddress, addressHolder.getPort());
                        }
                    } else if (AddressUtil.matchAnyInterface(inetAddresses[0].getHostAddress(), interfaces.getInterfaces())) {
                        return new Address(addressHolder.getAddress(), addressHolder.getPort());
                    }
                    break block8;
                }
                return new Address(addressHolder.getAddress(), addressHolder.getPort());
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return null;
    }

    protected Collection<Address> getPossibleAddresses() {
        Collection<String> possibleMembers = this.getMembers();
        HashSet<Address> possibleAddresses = new HashSet<Address>();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (String possibleMember : possibleMembers) {
            AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(possibleMember);
            try {
                boolean portIsDefined = addressHolder.getPort() != -1 || !networkConfig.isPortAutoIncrement();
                int count = portIsDefined ? 1 : this.maxPortTryCount;
                int port = addressHolder.getPort() != -1 ? addressHolder.getPort() : networkConfig.getPort();
                AddressUtil.AddressMatcher addressMatcher = null;
                try {
                    addressMatcher = AddressUtil.getAddressMatcher(addressHolder.getAddress());
                }
                catch (AddressUtil.InvalidAddressException ignore) {
                    EmptyStatement.ignore(ignore);
                }
                if (addressMatcher != null) {
                    Collection<String> matchedAddresses = addressMatcher.isIPv4() ? AddressUtil.getMatchingIpv4Addresses(addressMatcher) : Collections.singleton(addressHolder.getAddress());
                    for (String matchedAddress : matchedAddresses) {
                        this.addPossibleAddresses(possibleAddresses, null, InetAddress.getByName(matchedAddress), port, count);
                    }
                    continue;
                }
                String host = addressHolder.getAddress();
                InterfacesConfig interfaces = networkConfig.getInterfaces();
                if (interfaces.isEnabled()) {
                    InetAddress[] inetAddresses;
                    for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                        if (!AddressUtil.matchAnyInterface(inetAddress.getHostAddress(), interfaces.getInterfaces())) continue;
                        this.addPossibleAddresses(possibleAddresses, host, inetAddress, port, count);
                    }
                    continue;
                }
                this.addPossibleAddresses(possibleAddresses, host, null, port, count);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Cannot resolve hostname '" + addressHolder.getAddress() + "'. Please make sure host is valid and reachable.");
                if (!this.logger.isFineEnabled()) continue;
                this.logger.log(Level.FINE, "Error during resolving possible target!", e);
            }
        }
        possibleAddresses.remove(this.node.getThisAddress());
        return possibleAddresses;
    }

    private void addPossibleAddresses(Set<Address> possibleAddresses, String host, InetAddress inetAddress, int port, int count) throws UnknownHostException {
        for (int i = 0; i < count; ++i) {
            int currentPort = port + i;
            Address address = host != null && inetAddress != null ? new Address(host, inetAddress, currentPort) : (host != null ? new Address(host, currentPort) : new Address(inetAddress, currentPort));
            if (this.isLocalAddress(address)) continue;
            possibleAddresses.add(address);
        }
    }

    private boolean isLocalAddress(Address address) throws UnknownHostException {
        Address thisAddress = this.node.getThisAddress();
        boolean local = thisAddress.getInetSocketAddress().equals(address.getInetSocketAddress());
        if (this.logger.isFineEnabled()) {
            this.logger.fine(address + " is local? " + local);
        }
        return local;
    }

    protected Collection<String> getMembers() {
        return TcpIpJoiner.getConfigurationMembers(this.config);
    }

    public static Collection<String> getConfigurationMembers(Config config) {
        TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        List<String> configMembers = tcpIpConfig.getMembers();
        HashSet<String> possibleMembers = new HashSet<String>();
        for (String member : configMembers) {
            String[] members = member.split("[,; ]");
            Collections.addAll(possibleMembers, members);
        }
        return possibleMembers;
    }

    @Override
    public void searchForOtherClusters() {
        Collection<Address> possibleAddresses;
        try {
            possibleAddresses = this.getPossibleAddresses();
        }
        catch (Throwable e) {
            this.logger.severe(e);
            return;
        }
        possibleAddresses.remove(this.node.getThisAddress());
        possibleAddresses.removeAll(this.node.getClusterService().getMemberAddresses());
        if (possibleAddresses.isEmpty()) {
            return;
        }
        for (Address address : possibleAddresses) {
            JoinMessage response = this.sendSplitBrainJoinMessage(address);
            if (!this.shouldMerge(response)) continue;
            this.logger.warning(this.node.getThisAddress() + " is merging [tcp/ip] to " + address);
            this.setTargetAddress(address);
            this.startClusterMerge(address);
            return;
        }
    }

    @Override
    public String getType() {
        return "tcp-ip";
    }
}

