/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.collection;

import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionContainer;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionEvent;
import com.att.aft.dme2.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.att.aft.dme2.hazelcast.collection.impl.txncollection.operations.CollectionTransactionRollbackOperation;
import com.att.aft.dme2.hazelcast.core.ItemEventType;
import com.att.aft.dme2.hazelcast.core.ItemListener;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.att.aft.dme2.hazelcast.spi.EventPublishingService;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.TransactionalService;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public abstract class CollectionService
implements ManagedService,
RemoteService,
EventPublishingService<CollectionEvent, ItemListener>,
TransactionalService,
MigrationAwareService {
    protected final NodeEngine nodeEngine;
    private final ILogger logger;

    protected CollectionService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.getContainerMap().clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.getContainerMap().remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(this.getServiceName(), name);
    }

    public abstract CollectionContainer getOrCreateContainer(String var1, boolean var2);

    public abstract Map<String, ? extends CollectionContainer> getContainerMap();

    public abstract String getServiceName();

    @Override
    public void dispatchEvent(CollectionEvent event, ItemListener listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.getCaller());
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.getName(), event.getEventType(), event.getData(), member, this.nodeEngine.getSerializationService());
        if (member == null) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Dropping event " + itemEvent + " from unknown address:" + event.getCaller());
            }
            return;
        }
        if (event.getEventType().equals((Object)ItemEventType.ADDED)) {
            listener.itemAdded(itemEvent);
        } else {
            listener.itemRemoved(itemEvent);
        }
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        Set<String> collectionNames = this.getContainerMap().keySet();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : collectionNames) {
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new CollectionTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.executeOperation(operation);
        }
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    protected Map<String, CollectionContainer> getMigrationData(PartitionReplicationEvent event) {
        HashMap<String, CollectionContainer> migrationData = new HashMap<String, CollectionContainer>();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (Map.Entry<String, ? extends CollectionContainer> entry : this.getContainerMap().entrySet()) {
            String name = entry.getKey();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            CollectionContainer container = entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        return migrationData;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearCollectionsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Set<Map.Entry<String, ? extends CollectionContainer>> entrySet = this.getContainerMap().entrySet();
        Iterator<Map.Entry<String, ? extends CollectionContainer>> iterator = entrySet.iterator();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends CollectionContainer> entry = iterator.next();
            String name = entry.getKey();
            CollectionContainer container = entry.getValue();
            int containerPartitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator.remove();
        }
    }

    public void addContainer(String name, CollectionContainer container) {
        Map<String, ? extends CollectionContainer> map = this.getContainerMap();
        map.put(name, container);
    }
}

