/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.collection.operations;

import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionContainer;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionDataSerializerHook;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionEvent;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionEventFilter;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionService;
import com.att.aft.dme2.hazelcast.collection.impl.list.ListContainer;
import com.att.aft.dme2.hazelcast.collection.impl.list.ListService;
import com.att.aft.dme2.hazelcast.core.ItemEventType;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.Collection;

public abstract class CollectionOperation
extends Operation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected String name;
    protected transient Object response;
    private transient CollectionContainer container;

    protected CollectionOperation() {
    }

    protected CollectionOperation(String name) {
        this.name = name;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void afterRun() throws Exception {
    }

    protected final ListContainer getOrCreateListContainer() {
        if (this.container == null) {
            ListService service = (ListService)this.getService();
            try {
                this.container = service.getOrCreateContainer(this.name, this instanceof BackupOperation);
            }
            catch (Exception e) {
                throw new RetryableHazelcastException(e);
            }
        }
        return (ListContainer)this.container;
    }

    protected final CollectionContainer getOrCreateContainer() {
        if (this.container == null) {
            CollectionService service = (CollectionService)this.getService();
            try {
                this.container = service.getOrCreateContainer(this.name, this instanceof BackupOperation);
            }
            catch (Exception e) {
                throw new RetryableHazelcastException(e);
            }
        }
        return this.container;
    }

    protected void publishEvent(ItemEventType eventType, Data data) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.name);
        Address address = this.getNodeEngine().getThisAddress();
        for (EventRegistration registration : registrations) {
            CollectionEventFilter filter = (CollectionEventFilter)registration.getFilter();
            boolean includeValue = filter.isIncludeValue();
            CollectionEvent event = new CollectionEvent(this.name, includeValue ? data : null, eventType, address);
            eventService.publishEvent(this.getServiceName(), registration, (Object)event, this.name.hashCode());
        }
    }

    public boolean hasEnoughCapacity(int delta) {
        return this.getOrCreateContainer().hasEnoughCapacity(delta);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getFactoryId() {
        return CollectionDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }
}

