/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.collection.operations;

import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionContainer;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionDataSerializerHook;
import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionService;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.Map;

public abstract class CollectionReplicationOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    protected Map<String, CollectionContainer> migrationData;

    public CollectionReplicationOperation() {
    }

    public CollectionReplicationOperation(Map<String, CollectionContainer> migrationData, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.migrationData = migrationData;
    }

    @Override
    public void run() throws Exception {
        CollectionService service = (CollectionService)this.getService();
        for (Map.Entry<String, CollectionContainer> entry : this.migrationData.entrySet()) {
            String name = entry.getKey();
            CollectionContainer container = entry.getValue();
            container.init(this.getNodeEngine());
            service.addContainer(name, container);
        }
    }

    @Override
    public int getFactoryId() {
        return CollectionDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (Map.Entry<String, CollectionContainer> entry : this.migrationData.entrySet()) {
            out.writeUTF(entry.getKey());
            CollectionContainer container = entry.getValue();
            container.writeData(out);
        }
    }
}

