/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.list.operations;

import com.att.aft.dme2.hazelcast.collection.impl.collection.CollectionItem;
import com.att.aft.dme2.hazelcast.collection.impl.collection.operations.CollectionBackupAwareOperation;
import com.att.aft.dme2.hazelcast.collection.impl.collection.operations.CollectionRemoveBackupOperation;
import com.att.aft.dme2.hazelcast.collection.impl.list.ListContainer;
import com.att.aft.dme2.hazelcast.core.ItemEventType;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;

public class ListRemoveOperation
extends CollectionBackupAwareOperation {
    private int index;
    private long itemId;

    public ListRemoveOperation() {
    }

    public ListRemoveOperation(String name, int index) {
        super(name);
        this.index = index;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionRemoveBackupOperation(this.name, this.itemId);
    }

    @Override
    public void beforeRun() throws Exception {
        this.publishEvent(ItemEventType.REMOVED, (Data)this.response);
    }

    @Override
    public void run() throws Exception {
        ListContainer listContainer = this.getOrCreateListContainer();
        CollectionItem item = listContainer.remove(this.index);
        this.itemId = item.getItemId();
        this.response = item.getValue();
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
    }
}

