/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.queue;

import com.att.aft.dme2.hazelcast.collection.impl.queue.operations.CheckAndEvictOperation;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import com.att.aft.dme2.hazelcast.util.scheduler.EntryTaskScheduler;
import com.att.aft.dme2.hazelcast.util.scheduler.ScheduledEntry;
import com.att.aft.dme2.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public class QueueEvictionProcessor
implements ScheduledEntryProcessor<String, Void> {
    private final NodeEngine nodeEngine;

    public QueueEvictionProcessor(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void process(EntryTaskScheduler<String, Void> scheduler, Collection<ScheduledEntry<String, Void>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (ScheduledEntry<String, Void> entry : entries) {
            String name = entry.getKey();
            int partitionId = partitionService.getPartitionId(this.nodeEngine.toData(name));
            Operation op = new CheckAndEvictOperation(entry.getKey()).setPartitionId(partitionId);
            operationService.invokeOnPartition(op).join();
        }
    }
}

