/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.queue;

import com.att.aft.dme2.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueContainer;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueEvent;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueEventFilter;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueEvictionProcessor;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueProxyImpl;
import com.att.aft.dme2.hazelcast.collection.impl.queue.operations.QueueReplicationOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.TransactionalQueueProxy;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.QueueTransactionRollbackOperation;
import com.att.aft.dme2.hazelcast.core.ItemEventType;
import com.att.aft.dme2.hazelcast.core.ItemListener;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.monitor.LocalQueueStats;
import com.att.aft.dme2.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.att.aft.dme2.hazelcast.spi.EventPublishingService;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.StatisticsAwareService;
import com.att.aft.dme2.hazelcast.spi.TaskScheduler;
import com.att.aft.dme2.hazelcast.spi.TransactionalService;
import com.att.aft.dme2.hazelcast.spi.partition.IPartition;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.transaction.impl.Transaction;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.MapUtil;
import com.att.aft.dme2.hazelcast.util.scheduler.EntryTaskScheduler;
import com.att.aft.dme2.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import com.att.aft.dme2.hazelcast.util.scheduler.ScheduleType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class QueueService
implements ManagedService,
MigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<QueueEvent, ItemListener>,
StatisticsAwareService {
    public static final String SERVICE_NAME = "hz:impl:queueService";
    private final EntryTaskScheduler queueEvictionScheduler;
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<String, QueueContainer> containerMap = new ConcurrentHashMap<String, QueueContainer>();
    private final ConcurrentMap<String, LocalQueueStatsImpl> statsMap = new ConcurrentHashMap<String, LocalQueueStatsImpl>(1000);
    private final ConstructorFunction<String, LocalQueueStatsImpl> localQueueStatsConstructorFunction = new ConstructorFunction<String, LocalQueueStatsImpl>(){

        @Override
        public LocalQueueStatsImpl createNew(String key) {
            return new LocalQueueStatsImpl();
        }
    };
    private final ILogger logger;

    public QueueService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        TaskScheduler globalScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
        QueueEvictionProcessor entryProcessor = new QueueEvictionProcessor(nodeEngine);
        this.queueEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(globalScheduler, entryProcessor, ScheduleType.POSTPONE);
        this.logger = nodeEngine.getLogger(QueueService.class);
    }

    public void scheduleEviction(String name, long delay) {
        this.queueEvictionScheduler.schedule(delay, name, null);
    }

    public void cancelEviction(String name) {
        this.queueEvictionScheduler.cancel(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.containerMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public QueueContainer getOrCreateContainer(String name, boolean fromBackup) throws Exception {
        QueueContainer container = (QueueContainer)this.containerMap.get(name);
        if (container != null) {
            return container;
        }
        container = new QueueContainer(name, this.nodeEngine.getConfig().findQueueConfig(name), this.nodeEngine, this);
        QueueContainer existing = this.containerMap.putIfAbsent(name, container);
        if (existing != null) {
            container = existing;
        } else {
            container.init(fromBackup);
        }
        return container;
    }

    public void addContainer(String name, QueueContainer container) {
        this.containerMap.put(name, container);
    }

    public boolean containsQueue(String name) {
        return this.containerMap.containsKey(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, QueueContainer> migrationData = new HashMap<String, QueueContainer>();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            QueueContainer container = (QueueContainer)entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new QueueReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearQueuesHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearQueuesHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearQueuesHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Iterator iterator = this.containerMap.entrySet().iterator();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            QueueContainer container = (QueueContainer)entry.getValue();
            int containerPartitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator.remove();
        }
    }

    @Override
    public void dispatchEvent(QueueEvent event, ItemListener listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.caller);
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.name, event.eventType, event.data, member, this.nodeEngine.getSerializationService());
        if (member == null) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Dropping event " + itemEvent + " from unknown address:" + event.caller);
            }
            return;
        }
        if (event.eventType.equals((Object)ItemEventType.ADDED)) {
            listener.itemAdded(itemEvent);
        } else {
            listener.itemRemoved(itemEvent);
        }
        this.getLocalQueueStatsImpl(event.name).incrementReceivedEvents();
    }

    @Override
    public QueueProxyImpl createDistributedObject(String objectId) {
        return new QueueProxyImpl(objectId, this, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.containerMap.remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    public String addItemListener(String name, ItemListener listener, boolean includeValue, boolean isLocal) {
        EventService eventService = this.nodeEngine.getEventService();
        QueueEventFilter filter = new QueueEventFilter(includeValue);
        EventRegistration registration = isLocal ? eventService.registerLocalListener(SERVICE_NAME, name, filter, listener) : eventService.registerListener(SERVICE_NAME, name, filter, listener);
        return registration.getId();
    }

    public boolean removeItemListener(String name, String registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public LocalQueueStats createLocalQueueStats(String name, int partitionId) {
        IPartition partition;
        Address owner;
        LocalQueueStatsImpl stats = this.getLocalQueueStatsImpl(name);
        stats.setOwnedItemCount(0);
        stats.setBackupItemCount(0);
        QueueContainer container = (QueueContainer)this.containerMap.get(name);
        if (container == null) {
            return stats;
        }
        Address thisAddress = this.nodeEngine.getClusterService().getThisAddress();
        if (thisAddress.equals(owner = (partition = this.nodeEngine.getPartitionService().getPartition(partitionId)).getOwnerOrNull())) {
            stats.setOwnedItemCount(container.size());
        } else if (owner != null) {
            stats.setBackupItemCount(container.backupSize());
        }
        container.setStats(stats);
        return stats;
    }

    public LocalQueueStats createLocalQueueStats(String name) {
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        Object keyData = serializationService.toData(name, StringPartitioningStrategy.INSTANCE);
        int partitionId = partitionService.getPartitionId((Data)keyData);
        return this.createLocalQueueStats(name, partitionId);
    }

    public LocalQueueStatsImpl getLocalQueueStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localQueueStatsConstructorFunction);
    }

    public TransactionalQueueProxy createTransactionalObject(String name, Transaction transaction) {
        return new TransactionalQueueProxy(this.nodeEngine, this, name, transaction);
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        Set queueNames = this.containerMap.keySet();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : queueNames) {
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new QueueTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.executeOperation(operation);
        }
    }

    public Map<String, LocalQueueStats> getStats() {
        Map<String, LocalQueueStats> queueStats = MapUtil.createHashMap(this.containerMap.size());
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            LocalQueueStats queueStat = this.createLocalQueueStats(name);
            queueStats.put(name, queueStat);
        }
        return queueStats;
    }
}

