/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.queue.operations;

import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueContainer;
import com.att.aft.dme2.hazelcast.collection.impl.queue.operations.ClearBackupOperation;
import com.att.aft.dme2.hazelcast.collection.impl.queue.operations.QueueBackupAwareOperation;
import com.att.aft.dme2.hazelcast.core.ItemEventType;
import com.att.aft.dme2.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.util.Map;

public class ClearOperation
extends QueueBackupAwareOperation
implements Notifier {
    private Map<Long, Data> dataMap;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void run() {
        QueueContainer queueContainer = this.getContainer();
        this.dataMap = queueContainer.clear();
        this.response = true;
    }

    @Override
    public void afterRun() throws Exception {
        LocalQueueStatsImpl stats = this.getQueueService().getLocalQueueStatsImpl(this.name);
        stats.incrementOtherOperations();
        for (Data data : this.dataMap.values()) {
            this.publishEvent(ItemEventType.REMOVED, data);
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.name, this.dataMap.keySet());
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(!this.dataMap.isEmpty());
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(!this.dataMap.isEmpty());
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getContainer().getOfferWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 8;
    }
}

