/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.queue.operations;

import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueContainer;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueDataSerializerHook;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueService;
import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.QueueConfig;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class QueueReplicationOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private Map<String, QueueContainer> migrationData;

    public QueueReplicationOperation() {
    }

    public QueueReplicationOperation(Map<String, QueueContainer> migrationData, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.migrationData = migrationData;
    }

    @Override
    public void run() {
        QueueService service = (QueueService)this.getService();
        NodeEngine nodeEngine = this.getNodeEngine();
        Config config = nodeEngine.getConfig();
        for (Map.Entry<String, QueueContainer> entry : this.migrationData.entrySet()) {
            String name = entry.getKey();
            QueueContainer container = entry.getValue();
            QueueConfig conf = config.findQueueConfig(name);
            container.setConfig(conf, nodeEngine, service);
            service.addContainer(name, container);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (Map.Entry<String, QueueContainer> entry : this.migrationData.entrySet()) {
            out.writeUTF(entry.getKey());
            QueueContainer container = entry.getValue();
            container.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.migrationData = new HashMap<String, QueueContainer>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String name = in.readUTF();
            QueueContainer container = new QueueContainer(name);
            container.readData(in);
            this.migrationData.put(name, container);
        }
    }
}

