/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.collection.impl.txnqueue;

import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueItem;
import com.att.aft.dme2.hazelcast.collection.impl.queue.QueueService;
import com.att.aft.dme2.hazelcast.collection.impl.queue.operations.SizeOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.QueueTransactionLogRecord;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.BaseTxnQueueOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.TxnOfferOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.TxnPeekOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.TxnPollOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.TxnReserveOfferOperation;
import com.att.aft.dme2.hazelcast.collection.impl.txnqueue.operations.TxnReservePollOperation;
import com.att.aft.dme2.hazelcast.config.QueueConfig;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.TransactionalDistributedObject;
import com.att.aft.dme2.hazelcast.transaction.TransactionException;
import com.att.aft.dme2.hazelcast.transaction.TransactionNotActiveException;
import com.att.aft.dme2.hazelcast.transaction.TransactionalObject;
import com.att.aft.dme2.hazelcast.transaction.impl.Transaction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class TransactionalQueueProxySupport
extends TransactionalDistributedObject<QueueService>
implements TransactionalObject {
    protected final String name;
    protected final int partitionId;
    protected final QueueConfig config;
    private final LinkedList<QueueItem> offeredQueue = new LinkedList();
    private final Set<Long> itemIdSet = new HashSet<Long>();

    protected TransactionalQueueProxySupport(NodeEngine nodeEngine, QueueService service, String name, Transaction tx) {
        super(nodeEngine, service, tx);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
        this.config = nodeEngine.getConfig().findQueueConfig(name);
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    public boolean offerInternal(Data data, long timeout) {
        TxnReserveOfferOperation operation = new TxnReserveOfferOperation(this.name, timeout, this.offeredQueue.size(), this.tx.getTxnId());
        operation.setCallerUuid(this.tx.getOwnerUuid());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            Long itemId = (Long)f.get();
            if (itemId != null) {
                if (!this.itemIdSet.add(itemId)) {
                    throw new TransactionException("Duplicate itemId: " + itemId);
                }
                this.offeredQueue.offer(new QueueItem(null, itemId, data));
                TxnOfferOperation txnOfferOperation = new TxnOfferOperation(this.name, itemId, data);
                this.putToRecord(txnOfferOperation);
                return true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return false;
    }

    private void putToRecord(BaseTxnQueueOperation operation) {
        QueueTransactionLogRecord logRecord = (QueueTransactionLogRecord)this.tx.get(this.name);
        if (logRecord == null) {
            logRecord = new QueueTransactionLogRecord(this.tx.getTxnId(), this.name, this.partitionId);
            this.tx.add(logRecord);
        }
        logRecord.addOperation(operation);
    }

    private void removeFromRecord(long itemId) {
        QueueTransactionLogRecord logRecord = (QueueTransactionLogRecord)this.tx.get(this.name);
        int size = logRecord.removeOperation(itemId);
        if (size == 0) {
            this.tx.remove(this.name);
        }
    }

    public Data pollInternal(long timeout) {
        QueueItem reservedOffer = this.offeredQueue.peek();
        long itemId = reservedOffer == null ? -1L : reservedOffer.getItemId();
        TxnReservePollOperation operation = new TxnReservePollOperation(this.name, timeout, itemId, this.tx.getTxnId());
        operation.setCallerUuid(this.tx.getOwnerUuid());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            QueueItem item = (QueueItem)f.get();
            if (item != null) {
                if (reservedOffer != null && item.getItemId() == reservedOffer.getItemId()) {
                    this.offeredQueue.poll();
                    this.removeFromRecord(reservedOffer.getItemId());
                    this.itemIdSet.remove(reservedOffer.getItemId());
                    return reservedOffer.getData();
                }
                if (!this.itemIdSet.add(item.getItemId())) {
                    throw new TransactionException("Duplicate itemId: " + item.getItemId());
                }
                TxnPollOperation txnPollOperation = new TxnPollOperation(this.name, item.getItemId());
                this.putToRecord(txnPollOperation);
                return item.getData();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return null;
    }

    public Data peekInternal(long timeout) {
        QueueItem offer = this.offeredQueue.peek();
        long itemId = offer == null ? -1L : offer.getItemId();
        TxnPeekOperation operation = new TxnPeekOperation(this.name, timeout, itemId, this.tx.getTxnId());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            QueueItem item = (QueueItem)f.get();
            if (item != null) {
                if (offer != null && item.getItemId() == offer.getItemId()) {
                    return offer.getData();
                }
                return item.getData();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return null;
    }

    public int size() {
        this.checkTransactionState();
        SizeOperation operation = new SizeOperation(this.name);
        try {
            InternalCompletableFuture f = this.invoke(operation);
            Integer size = (Integer)f.get();
            return size + this.offeredQueue.size();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private <E> InternalCompletableFuture<E> invoke(Operation operation) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        return operationService.invokeOnPartition("hz:impl:queueService", operation, this.partitionId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:queueService";
    }
}

