/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.atomiclong.operations;

import com.att.aft.dme2.hazelcast.concurrent.atomiclong.AtomicLongContainer;
import com.att.aft.dme2.hazelcast.concurrent.atomiclong.operations.AtomicLongBackupAwareOperation;
import com.att.aft.dme2.hazelcast.concurrent.atomiclong.operations.SetBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;

public class SetOperation
extends AtomicLongBackupAwareOperation {
    private long newValue;

    public SetOperation() {
    }

    public SetOperation(String name, long newValue) {
        super(name);
        this.newValue = newValue;
    }

    @Override
    public void run() throws Exception {
        AtomicLongContainer atomicLongContainer = this.getLongContainer();
        atomicLongContainer.set(this.newValue);
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.newValue);
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.newValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newValue = in.readLong();
    }
}

