/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.atomicreference.operations;

import com.att.aft.dme2.hazelcast.concurrent.atomicreference.AtomicReferenceContainer;
import com.att.aft.dme2.hazelcast.concurrent.atomicreference.AtomicReferenceDataSerializerHook;
import com.att.aft.dme2.hazelcast.concurrent.atomicreference.AtomicReferenceService;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AtomicReferenceReplicationOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private Map<String, Data> migrationData;

    public AtomicReferenceReplicationOperation() {
    }

    public AtomicReferenceReplicationOperation(Map<String, Data> migrationData) {
        this.migrationData = migrationData;
    }

    @Override
    public void run() throws Exception {
        AtomicReferenceService atomicReferenceService = (AtomicReferenceService)this.getService();
        for (Map.Entry<String, Data> entry : this.migrationData.entrySet()) {
            String name = entry.getKey();
            AtomicReferenceContainer atomicReferenceContainer = atomicReferenceService.getReferenceContainer(name);
            Data value = entry.getValue();
            atomicReferenceContainer.set(value);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicReferenceService";
    }

    @Override
    public int getFactoryId() {
        return AtomicReferenceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (Map.Entry<String, Data> entry : this.migrationData.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.migrationData = new HashMap<String, Data>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String name = in.readUTF();
            Data data = in.readData();
            this.migrationData.put(name, data);
        }
    }
}

