/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.atomicreference.operations;

import com.att.aft.dme2.hazelcast.concurrent.atomicreference.AtomicReferenceContainer;
import com.att.aft.dme2.hazelcast.concurrent.atomicreference.operations.AtomicReferenceBackupAwareOperation;
import com.att.aft.dme2.hazelcast.concurrent.atomicreference.operations.SetBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;

public class CompareAndSetOperation
extends AtomicReferenceBackupAwareOperation {
    private Data expect;
    private Data update;
    private boolean returnValue;

    public CompareAndSetOperation() {
    }

    public CompareAndSetOperation(String name, Data expect, Data update) {
        super(name);
        this.expect = expect;
        this.update = update;
    }

    @Override
    public void run() throws Exception {
        AtomicReferenceContainer atomicReferenceContainer = this.getReferenceContainer();
        this.shouldBackup = this.returnValue = atomicReferenceContainer.compareAndSet(this.expect, this.update);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.update);
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.expect);
        out.writeData(this.update);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expect = in.readData();
        this.update = in.readData();
    }
}

