/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.countdownlatch;

import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.CountDownLatchContainer;
import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.CountDownLatchProxy;
import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.operations.CountDownLatchReplicationOperation;
import com.att.aft.dme2.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CountDownLatchService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:countDownLatchService";
    private final ConcurrentMap<String, CountDownLatchContainer> containers = new ConcurrentHashMap<String, CountDownLatchContainer>();
    private NodeEngine nodeEngine;

    public int getCount(String name) {
        CountDownLatchContainer latch = (CountDownLatchContainer)this.containers.get(name);
        return latch != null ? latch.getCount() : 0;
    }

    public boolean setCount(String name, int count) {
        if (count < 0) {
            this.containers.remove(name);
            return false;
        }
        CountDownLatchContainer latch = (CountDownLatchContainer)this.containers.get(name);
        if (latch == null) {
            latch = new CountDownLatchContainer(name);
            this.containers.put(name, latch);
        }
        return latch.setCount(count);
    }

    public void setCountDirect(String name, int count) {
        if (count < 0) {
            this.containers.remove(name);
        } else {
            CountDownLatchContainer latch = (CountDownLatchContainer)this.containers.get(name);
            if (latch == null) {
                latch = new CountDownLatchContainer(name);
                this.containers.put(name, latch);
            }
            latch.setCountDirect(count);
        }
    }

    public void countDown(String name) {
        CountDownLatchContainer latch = (CountDownLatchContainer)this.containers.get(name);
        if (latch != null && latch.countDown() == 0) {
            this.containers.remove(name);
        }
    }

    public boolean shouldWait(String name) {
        CountDownLatchContainer latch = (CountDownLatchContainer)this.containers.get(name);
        return latch != null && latch.getCount() > 0;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.containers.clear();
    }

    @Override
    public CountDownLatchProxy createDistributedObject(String name) {
        return new CountDownLatchProxy(name, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.containers.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        LinkedList<CountDownLatchContainer> data = new LinkedList<CountDownLatchContainer>();
        for (Map.Entry latchEntry : this.containers.entrySet()) {
            String name = (String)latchEntry.getKey();
            if (this.getPartitionId(name) != event.getPartitionId()) continue;
            CountDownLatchContainer value = (CountDownLatchContainer)latchEntry.getValue();
            data.add(value);
        }
        return data.isEmpty() ? null : new CountDownLatchReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            int partitionId = event.getPartitionId();
            int thresholdReplicaIndex = event.getNewReplicaIndex();
            if (thresholdReplicaIndex == -1 || thresholdReplicaIndex > 1) {
                this.clearPartitionReplica(partitionId);
            }
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            int partitionId = event.getPartitionId();
            int thresholdReplicaIndex = event.getCurrentReplicaIndex();
            if (thresholdReplicaIndex == -1 || thresholdReplicaIndex > 1) {
                this.clearPartitionReplica(partitionId);
            }
        }
    }

    private int getPartitionId(String name) {
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return this.nodeEngine.getPartitionService().getPartitionId(partitionKey);
    }

    private void clearPartitionReplica(int partitionId) {
        Iterator iter = this.containers.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.getPartitionId(name) != partitionId) continue;
            iter.remove();
        }
    }

    public CountDownLatchContainer getCountDownLatchContainer(String name) {
        return (CountDownLatchContainer)this.containers.get(name);
    }

    public boolean containsLatch(String name) {
        return this.containers.containsKey(name);
    }

    public void add(CountDownLatchContainer latch) {
        String name = latch.getName();
        this.containers.put(name, latch);
    }
}

