/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.countdownlatch.operations;

import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.CountDownLatchContainer;
import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.CountDownLatchDataSerializerHook;
import com.att.aft.dme2.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class CountDownLatchReplicationOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private Collection<CountDownLatchContainer> data;

    public CountDownLatchReplicationOperation() {
    }

    public CountDownLatchReplicationOperation(Collection<CountDownLatchContainer> data) {
        this.data = data;
    }

    @Override
    public void run() throws Exception {
        if (this.data == null) {
            return;
        }
        CountDownLatchService service = (CountDownLatchService)this.getService();
        for (CountDownLatchContainer latchContainer : this.data) {
            service.add(latchContainer);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int len = this.data != null ? this.data.size() : 0;
        out.writeInt(len);
        if (len > 0) {
            for (CountDownLatchContainer latchContainer : this.data) {
                latchContainer.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.data = new ArrayList<CountDownLatchContainer>();
            for (int i = 0; i < len; ++i) {
                CountDownLatchContainer latchContainer = new CountDownLatchContainer();
                latchContainer.readData(in);
                this.data.add(latchContainer);
            }
        }
    }
}

