/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock;

import com.att.aft.dme2.hazelcast.concurrent.lock.operations.UnlockIfLeaseExpiredOperation;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationAccessor;
import com.att.aft.dme2.hazelcast.spi.OperationResponseHandler;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.exception.RetryableException;
import com.att.aft.dme2.hazelcast.util.scheduler.EntryTaskScheduler;
import com.att.aft.dme2.hazelcast.util.scheduler.ScheduledEntry;
import com.att.aft.dme2.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public final class LockEvictionProcessor
implements ScheduledEntryProcessor<Data, Integer> {
    private final NodeEngine nodeEngine;
    private final ObjectNamespace namespace;
    private final ILogger logger;
    private final OperationResponseHandler unlockResponseHandler;

    public LockEvictionProcessor(NodeEngine nodeEngine, ObjectNamespace namespace) {
        this.nodeEngine = nodeEngine;
        this.namespace = namespace;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.unlockResponseHandler = new UnlockResponseHandler();
    }

    @Override
    public void process(EntryTaskScheduler<Data, Integer> scheduler, Collection<ScheduledEntry<Data, Integer>> entries) {
        for (ScheduledEntry<Data, Integer> entry : entries) {
            Data key = entry.getKey();
            int version = entry.getValue();
            this.sendUnlockOperation(key, version);
        }
    }

    private void sendUnlockOperation(Data key, int version) {
        UnlockIfLeaseExpiredOperation operation = new UnlockIfLeaseExpiredOperation(this.namespace, key, version);
        try {
            this.submit(operation, key);
        }
        catch (Throwable t) {
            this.logger.warning(t);
        }
    }

    private void submit(UnlockOperation operation, Data key) {
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
        OperationService operationService = this.nodeEngine.getOperationService();
        operation.setNodeEngine(this.nodeEngine);
        operation.setServiceName("hz:impl:lockService");
        operation.setPartitionId(partitionId);
        OperationAccessor.setCallerAddress(operation, this.nodeEngine.getThisAddress());
        operation.setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
        operation.setOperationResponseHandler(this.unlockResponseHandler);
        operation.setValidateTarget(false);
        operation.setAsyncBackup(true);
        operationService.executeOperation(operation);
    }

    private class UnlockResponseHandler
    implements OperationResponseHandler {
        private UnlockResponseHandler() {
        }

        public void sendResponse(Operation op, Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                if (t instanceof RetryableException) {
                    LockEvictionProcessor.this.logger.finest("While unlocking... " + t.getMessage());
                } else {
                    LockEvictionProcessor.this.logger.warning(t);
                }
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

