/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockDataSerializerHook;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockServiceImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public abstract class AbstractLockOperation
extends AbstractOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    public static final int ANY_THREAD = 0;
    protected ObjectNamespace namespace;
    protected Data key;
    protected long threadId;
    protected long leaseTime = -1L;
    protected transient Object response;
    private transient boolean asyncBackup;
    private long referenceCallId;

    public AbstractLockOperation() {
    }

    protected AbstractLockOperation(ObjectNamespace namespace, Data key, long threadId) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
    }

    protected AbstractLockOperation(ObjectNamespace namespace, Data key, long threadId, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.setWaitTimeout(timeout);
    }

    public AbstractLockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.leaseTime = leaseTime;
        this.setWaitTimeout(timeout);
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    protected final LockStoreImpl getLockStore() {
        LockServiceImpl service = (LockServiceImpl)this.getService();
        return service.getLockStore(this.getPartitionId(), this.namespace);
    }

    public final int getSyncBackupCount() {
        if (this.asyncBackup) {
            return 0;
        }
        return this.getLockStore().getBackupCount();
    }

    public final int getAsyncBackupCount() {
        LockStoreImpl lockStore = this.getLockStore();
        if (this.asyncBackup) {
            return lockStore.getBackupCount() + lockStore.getAsyncBackupCount();
        }
        return lockStore.getAsyncBackupCount();
    }

    public final void setAsyncBackup(boolean asyncBackup) {
        this.asyncBackup = asyncBackup;
    }

    @Override
    protected void onSetCallId() {
        if (this.referenceCallId == 0L) {
            this.referenceCallId = this.getCallId();
        }
    }

    protected final long getReferenceCallId() {
        return this.referenceCallId != 0L ? this.referenceCallId : this.getCallId();
    }

    protected final void setReferenceCallId(long refCallId) {
        this.referenceCallId = refCallId;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    public final Data getKey() {
        return this.key;
    }

    @Override
    public final int getFactoryId() {
        return LockDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.namespace);
        out.writeData(this.key);
        out.writeLong(this.threadId);
        out.writeLong(this.leaseTime);
        out.writeLong(this.referenceCallId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.namespace = (ObjectNamespace)in.readObject();
        this.key = in.readData();
        this.threadId = in.readLong();
        this.leaseTime = in.readLong();
        this.referenceCallId = in.readLong();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", namespace=").append(this.namespace);
        sb.append(", threadId=").append(this.threadId);
    }
}

