/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.AbstractLockOperation;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.BeforeAwaitBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class BeforeAwaitOperation
extends AbstractLockOperation
implements Notifier,
BackupAwareOperation {
    private String conditionId;

    public BeforeAwaitOperation() {
    }

    public BeforeAwaitOperation(ObjectNamespace namespace, Data key, long threadId, String conditionId) {
        super(namespace, key, threadId);
        this.conditionId = conditionId;
    }

    public BeforeAwaitOperation(ObjectNamespace namespace, Data key, long threadId, String conditionId, long referenceId) {
        super(namespace, key, threadId);
        this.conditionId = conditionId;
        this.setReferenceCallId(referenceId);
    }

    @Override
    public void beforeRun() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        boolean isLockOwner = lockStore.isLockedBy(this.key, this.getCallerUuid(), this.threadId);
        this.ensureOwner(lockStore, isLockOwner);
    }

    private void ensureOwner(LockStoreImpl lockStore, boolean isLockOwner) {
        if (!isLockOwner) {
            throw new IllegalMonitorStateException("Current thread is not owner of the lock! -> " + lockStore.getOwnerInfo(this.key));
        }
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        lockStore.addAwait(this.key, this.conditionId, this.getCallerUuid(), this.threadId);
        lockStore.unlock(this.key, this.getCallerUuid(), this.threadId, this.getReferenceCallId());
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new BeforeAwaitBackupOperation(this.namespace, this.key, this.threadId, this.conditionId, this.getCallerUuid());
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        LockStoreImpl lockStore = this.getLockStore();
        return lockStore.getNotifiedKey(this.key);
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.conditionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.conditionId = in.readUTF();
    }
}

